import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { ServicesTableClient } from "@/features/statewide-services/components/services.table.client";
import { WorkflowButtonAdd } from "@/features/statewide-services/components/workflow.button-add";
import { WorkflowDialogClient } from "@/features/statewide-services/components/workflow.dialog.client";

export const dynamic = 'force-dynamic'

export default async function AgencyStatewideServices() {
  return (
    <div className="flex flex-col gap-3 w-full overflow-hidden rounded-sm">
      <Card>
        <CardHeader className="relative pr-20">
          <CardTitle>Statewide services</CardTitle>
          <CardDescription>Showing statewide services the way they will show up within the trip planner.</CardDescription>

          <WorkflowButtonAdd />
        </CardHeader>

        <CardContent className="pb-0">
          <ServicesTableClient />
        </CardContent>
      </Card>

      <WorkflowDialogClient />
    </div>
  );
}

